<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["cert_uni"] ) ) {
			$lookupTableLinks["cert_uni"] = array();
		}
		if( !isset( $lookupTableLinks["cert_uni"]["naser_users.cert"] )) {
			$lookupTableLinks["cert_uni"]["naser_users.cert"] = array();
		}
		$lookupTableLinks["cert_uni"]["naser_users.cert"]["edit"] = array("table" => "naser_users", "field" => "cert", "page" => "edit");
		if( !isset( $lookupTableLinks["universities"] ) ) {
			$lookupTableLinks["universities"] = array();
		}
		if( !isset( $lookupTableLinks["universities"]["naser_users.unis"] )) {
			$lookupTableLinks["universities"]["naser_users.unis"] = array();
		}
		$lookupTableLinks["universities"]["naser_users.unis"]["edit"] = array("table" => "naser_users", "field" => "unis", "page" => "edit");
		if( !isset( $lookupTableLinks["certs"] ) ) {
			$lookupTableLinks["certs"] = array();
		}
		if( !isset( $lookupTableLinks["certs"]["naser_users.typ"] )) {
			$lookupTableLinks["certs"]["naser_users.typ"] = array();
		}
		$lookupTableLinks["certs"]["naser_users.typ"]["edit"] = array("table" => "naser_users", "field" => "typ", "page" => "edit");
		if( !isset( $lookupTableLinks["spess"] ) ) {
			$lookupTableLinks["spess"] = array();
		}
		if( !isset( $lookupTableLinks["spess"]["naser_users.spes"] )) {
			$lookupTableLinks["spess"]["naser_users.spes"] = array();
		}
		$lookupTableLinks["spess"]["naser_users.spes"]["edit"] = array("table" => "naser_users", "field" => "spes", "page" => "edit");
		if( !isset( $lookupTableLinks["cert_uni"] ) ) {
			$lookupTableLinks["cert_uni"] = array();
		}
		if( !isset( $lookupTableLinks["cert_uni"]["profile.cert"] )) {
			$lookupTableLinks["cert_uni"]["profile.cert"] = array();
		}
		$lookupTableLinks["cert_uni"]["profile.cert"]["edit"] = array("table" => "profile", "field" => "cert", "page" => "edit");
		if( !isset( $lookupTableLinks["universities"] ) ) {
			$lookupTableLinks["universities"] = array();
		}
		if( !isset( $lookupTableLinks["universities"]["profile.unis"] )) {
			$lookupTableLinks["universities"]["profile.unis"] = array();
		}
		$lookupTableLinks["universities"]["profile.unis"]["edit"] = array("table" => "profile", "field" => "unis", "page" => "edit");
		if( !isset( $lookupTableLinks["certs"] ) ) {
			$lookupTableLinks["certs"] = array();
		}
		if( !isset( $lookupTableLinks["certs"]["profile.typ"] )) {
			$lookupTableLinks["certs"]["profile.typ"] = array();
		}
		$lookupTableLinks["certs"]["profile.typ"]["edit"] = array("table" => "profile", "field" => "typ", "page" => "edit");
		if( !isset( $lookupTableLinks["spess"] ) ) {
			$lookupTableLinks["spess"] = array();
		}
		if( !isset( $lookupTableLinks["spess"]["profile.spes"] )) {
			$lookupTableLinks["spess"]["profile.spes"] = array();
		}
		$lookupTableLinks["spess"]["profile.spes"]["edit"] = array("table" => "profile", "field" => "spes", "page" => "edit");
}

?>